// Style Templates
// ===========================================================================
var h1StyleTemplate = (function () {/*
    h1 {
      color: rgba(#red, #green, #blue, #alpha);
    }
*/}).toString().match(/[^]*\/\*([^]*)\*\/\}$/)[1];

var htmlStyleTemplate = (function () {/*
    html {
      background: rgba(#backgroundRed, #backgroundGreen, #backgroundBlue, #backgroundAlpha);
      color: rgba(#red, #green, #blue, #alpha);
    }
*/}).toString().match(/[^]*\/\*([^]*)\*\/\}$/)[1];

var btnStyleTemplate = (function () {/*
    .btn-primary {
      background-image: -webkit-linear-gradient(top, rgba(#lighterRed, #lighterGreen, #lighterBlue, #lighterAlpha), rgba(#red, #green, #blue, #alpha));
    }
*/}).toString().match(/[^]*\/\*([^]*)\*\/\}$/)[1];

// Style Update
// ===========================================================================
var updateH1Style = function(red, green, blue, alpha){
  var style = h1StyleTemplate;
  style = style.replace("#red", red);
  style = style.replace("#green", green);
  style = style.replace("#blue", blue);
  style = style.replace("#alpha", alpha);
  addRule(style);
}

var updateHTMLStyle = function(backgroundRed, backgroundGreen, backgroundBlue, backgroundAlpha, red, green, blue, alpha){
  var style = htmlStyleTemplate;
  style = style.replace("#backgroundRed", backgroundRed);
  style = style.replace("#backgroundGreen", backgroundGreen);
  style = style.replace("#backgroundBlue", backgroundBlue);
  style = style.replace("#backgroundAlpha", backgroundAlpha);
  style = style.replace("#red", red);
  style = style.replace("#green", green);
  style = style.replace("#blue", blue);
  style = style.replace("#alpha", alpha);
  addRule(style);
}

var updateBTNStyle = function(lighterRed, lighterGreen, lighterBlue, lighterAlpha, red, green, blue, alpha){
  var style = btnStyleTemplate;
  style = style.replace("#lighterRed", lighterRed);
  style = style.replace("#lighterGreen", lighterGreen);
  style = style.replace("#lighterBlue", lighterBlue);
  style = style.replace("#lighterAlpha", lighterAlpha);
  style = style.replace("#red", red);
  style = style.replace("#green", green);
  style = style.replace("#blue", blue);
  style = style.replace("#alpha", alpha);
  addRule(style);
}



// Style sheet
// ===========================================================================
var sheet = (function() {
  // Create the <style> tag
  var style = document.createElement("style");

  // WebKit hack :(
  style.appendChild(document.createTextNode(""));

  // Add the <style> element to the page
  document.head.appendChild(style);

  return style.sheet;
})();

var addRule = function(rule) {
  sheet.insertRule(rule, sheet.rules.length);
}

updateH1Style(80,80,80,1.0);
updateHTMLStyle(255,255,255,1.0, 120,120,120,1.0);
updateBTNStyle(68,169,251,1.0, 65,148,242,1.0);



$(document).ready(function() {
  var words = [
    "Oooh, a new project, how exciting!",
    "Get you, starting a new project!",
    "Thanks for using RapidWeaver!",
    "Make this project a good one!",
    "Don\u2019t Stop Be-Weavin’",
    "Always Be Weaving!",
    "Great things are afoot!",
    "Make it so",
    "Let\u2019s make something wonderful",
    "You look nice today!"
  ];

  var word = words[Math.floor(Math.random()*words.length)];
  $('.title').append(word);

  var welcomeHeight = '-' + $('.welcome-text').outerHeight()/2 + 'px';
  $('.welcome-text').css('margin-top', welcomeHeight);
});
